/*Copyright (c) 2015-2016 wavemaker-com All Rights Reserved.
 This software is the confidential and proprietary information of wavemaker-com You shall not disclose such Confidential Information and shall use it only in accordance
 with the terms of the source code license agreement you entered into with wavemaker-com*/
package com.todo.todo.service;

/*This is a Studio Managed File. DO NOT EDIT THIS FILE. Your changes may be reverted by Studio.*/

import java.util.Map;

import javax.validation.Valid;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.wavemaker.runtime.data.exception.EntityNotFoundException;
import com.wavemaker.runtime.data.export.ExportType;
import com.wavemaker.runtime.data.expression.QueryFilter;
import com.wavemaker.runtime.data.model.AggregationInfo;
import com.wavemaker.runtime.file.model.Downloadable;

import com.todo.todo.Todo;

/**
 * Service object for domain model class {@link Todo}.
 */
public interface TodoService {

    /**
     * Creates a new Todo. It does cascade insert for all the children in a single transaction.
     *
     * This method overrides the input field values using Server side or database managed properties defined on Todo if any.
     *
     * @param todo Details of the Todo to be created; value cannot be null.
     * @return The newly created Todo.
     */
	Todo create(@Valid Todo todo);


	/**
	 * Returns Todo by given id if exists.
	 *
	 * @param todoId The id of the Todo to get; value cannot be null.
	 * @return Todo associated with the given todoId.
     * @throws EntityNotFoundException If no Todo is found.
	 */
	Todo getById(Integer todoId) throws EntityNotFoundException;

    /**
	 * Find and return the Todo by given id if exists, returns null otherwise.
	 *
	 * @param todoId The id of the Todo to get; value cannot be null.
	 * @return Todo associated with the given todoId.
	 */
	Todo findById(Integer todoId);


	/**
	 * Updates the details of an existing Todo. It replaces all fields of the existing Todo with the given todo.
	 *
     * This method overrides the input field values using Server side or database managed properties defined on Todo if any.
     *
	 * @param todo The details of the Todo to be updated; value cannot be null.
	 * @return The updated Todo.
	 * @throws EntityNotFoundException if no Todo is found with given input.
	 */
	Todo update(@Valid Todo todo) throws EntityNotFoundException;

    /**
	 * Deletes an existing Todo with the given id.
	 *
	 * @param todoId The id of the Todo to be deleted; value cannot be null.
	 * @return The deleted Todo.
	 * @throws EntityNotFoundException if no Todo found with the given id.
	 */
	Todo delete(Integer todoId) throws EntityNotFoundException;

	/**
	 * Find all Todos matching the given QueryFilter(s).
     * All the QueryFilter(s) are ANDed to filter the results.
     * This method returns Paginated results.
	 *
     * @deprecated Use {@link #findAll(String, Pageable)} instead.
	 *
     * @param queryFilters Array of queryFilters to filter the results; No filters applied if the input is null/empty.
     * @param pageable Details of the pagination information along with the sorting options. If null returns all matching records.
     * @return Paginated list of matching Todos.
     *
     * @see QueryFilter
     * @see Pageable
     * @see Page
	 */
    @Deprecated
	Page<Todo> findAll(QueryFilter[] queryFilters, Pageable pageable);

    /**
	 * Find all Todos matching the given input query. This method returns Paginated results.
     * Note: Go through the documentation for <u>query</u> syntax.
	 *
     * @param query The query to filter the results; No filters applied if the input is null/empty.
     * @param pageable Details of the pagination information along with the sorting options. If null returns all matching records.
     * @return Paginated list of matching Todos.
     *
     * @see Pageable
     * @see Page
	 */
    Page<Todo> findAll(String query, Pageable pageable);

    /**
	 * Exports all Todos matching the given input query to the given exportType format.
     * Note: Go through the documentation for <u>query</u> syntax.
	 *
     * @param exportType The format in which to export the data; value cannot be null.
     * @param query The query to filter the results; No filters applied if the input is null/empty.
     * @param pageable Details of the pagination information along with the sorting options. If null exports all matching records.
     * @return The Downloadable file in given export type.
     *
     * @see Pageable
     * @see ExportType
     * @see Downloadable
	 */
    Downloadable export(ExportType exportType, String query, Pageable pageable);

	/**
	 * Retrieve the count of the Todos in the repository with matching query.
     * Note: Go through the documentation for <u>query</u> syntax.
     *
     * @param query query to filter results. No filters applied if the input is null/empty.
	 * @return The count of the Todo.
	 */
	long count(String query);

	/**
	 * Retrieve aggregated values with matching aggregation info.
     *
     * @param aggregationInfo info related to aggregations.
     * @param pageable Details of the pagination information along with the sorting options. If null exports all matching records.
	 * @return Paginated data with included fields.

     * @see AggregationInfo
     * @see Pageable
     * @see Page
	 */
	Page<Map<String, Object>> getAggregatedValues(AggregationInfo aggregationInfo, Pageable pageable);


}

